/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.hollingsworth.arsnouveau.client.container.CraftingTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.IAutoFillTerminal;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.common.network.ClientTransferHandlerPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.setup.registry.MenuRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalTransferHandler<C extends AbstractContainerMenu>
implements IRecipeTransferHandler<C, RecipeHolder<CraftingRecipe>> {
    private final Class<C> containerClass;
    private final IRecipeTransferHandlerHelper helper;
    private static final List<Class<? extends AbstractContainerMenu>> containerClasses = new ArrayList<Class<? extends AbstractContainerMenu>>();
    private static final IRecipeTransferError ERROR_INSTANCE = new IRecipeTransferError(){

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }
    };

    public CraftingTerminalTransferHandler(Class<C> containerClass, IRecipeTransferHandlerHelper helper) {
        this.containerClass = containerClass;
        this.helper = helper;
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(C container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (container instanceof IAutoFillTerminal) {
            C term = container;
            ArrayList<IRecipeSlotView> missing = new ArrayList<IRecipeSlotView>();
            List views = recipeSlots.getSlotViews();
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
            HashSet<StoredItemStack> stored = new HashSet<StoredItemStack>(term.getStoredItems());
            for (IRecipeSlotView view : views) {
                if (view.getRole() != RecipeIngredientRole.INPUT && view.getRole() != RecipeIngredientRole.CATALYST) continue;
                List possibleStacks = view.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toList();
                if (possibleStacks.isEmpty()) {
                    inputs.add(List.of());
                    continue;
                }
                inputs.add(possibleStacks);
                boolean found = false;
                for (ItemStack stack : possibleStacks) {
                    if (stack == null || player.getInventory().findSlotMatchingItem(stack) == -1) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (ItemStack stack : possibleStacks) {
                        StoredItemStack s = new StoredItemStack(stack);
                        if (!stored.contains(s)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                missing.add(view);
            }
            if (doTransfer) {
                Networking.sendToServer(new ClientTransferHandlerPacket(inputs));
            }
            if (!missing.isEmpty()) {
                return new TransferWarning(this.helper.createUserErrorForMissingSlots((Component)Component.translatable((String)"tooltip.ars_nouveau.items_missing"), missing));
            }
        } else {
            return ERROR_INSTANCE;
        }
        return null;
    }

    public static void registerTransferHandlers(IRecipeTransferRegistration recipeTransferRegistry) {
        for (Class<? extends AbstractContainerMenu> aClass : containerClasses) {
            recipeTransferRegistry.addRecipeTransferHandler(new CraftingTerminalTransferHandler<AbstractContainerMenu>(aClass, recipeTransferRegistry.getTransferHelper()), RecipeTypes.CRAFTING);
        }
    }

    public Optional<MenuType<C>> getMenuType() {
        return Optional.of((MenuType)MenuRegistry.STORAGE.get());
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    static {
        containerClasses.add(CraftingTerminalMenu.class);
    }

    private static class TransferWarning
    implements IRecipeTransferError {
        private final IRecipeTransferError parent;

        public TransferWarning(IRecipeTransferError parent) {
            this.parent = parent;
        }

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public void showError(GuiGraphics matrixStack, int mouseX, int mouseY, IRecipeSlotsView recipeLayout, int recipeX, int recipeY) {
            this.parent.showError(matrixStack, mouseX, mouseY, recipeLayout, recipeX, recipeY);
        }
    }
}

